﻿var importSortSample = {
    context: $(".v-sort-sample"),
    autocomplete: null,
    initialize: function () {
        var projectId = $("#ProjectId", importSortSample.context).val();
        importSortSample.autocomplete = $(".h-sortSampleQuestion").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetBrowseSortSampleQuestions", "Data", { projectId: projectId }),
            valueProperty: "Code",
            labelProperty: "Label",
            altValueField: $("#SelectedQuestions"),
            maxItems: 3,
            multipleSelection: true,
            hideSelectedItems: true
        });


        var option = $("input[name='Sort']:checked").val();
        $("#Questions", importSortSample.context).closest(".section").toggleClass("hidden", option == "RandomShuffle");
    },
    bindEvents: function () {
        importSortSample.context.on("change", "input[name='Sort']", function () {
            var option = $(this).val();
            var questionsSection = $("#Questions", importSortSample.context).closest(".section");
            
            questionsSection.toggleClass("hidden", option == "RandomShuffle");
            if (option == "RandomShuffle")
                importSortSample.autocomplete.a4autocomplete("clearValue");
        });
    }
};


$(document).ready(function () {
    if (importSortSample.context.length > 0) {
        importSortSample.initialize();
        importSortSample.bindEvents();
    }
});
